local main_loop = loadfile("squirrelscripts/main_ai_loop.nut");
dofile("squirrelscripts/ai_functions.nut");

function init() {
	timer <- 1200;
	found_defector <- false;
}

function check_if_caught_up_with_defector() {
	//maybe play "we've caught up with defector"
	if (!found_defector) {
		foreach(squad in my_squads) {
			if (squad.get_type() == 1) {
				if (squad.get_distance(side_1_squads[0]) < 1000) {
					wakeup_mission_script(0);
					found_defector = true;
					break;
				}
			}
		}
	}
}

function move_all_big_towards_defector(defector_pos) {
	foreach(squad in my_squads) {
		type = squad.get_type();
		if (type == 2 || type == 3)
			squad.select();
	}
	order_move(defector_pos[0], defector_pos[1]);
}

function run_ai() {
	if (side_1_squads.len() < 1)
		return;
		
	check_if_caught_up_with_defector();
	
	local defector_pos = side_1_squads[0].get_pos();
	move_all_big_towards_defector(defector_pos);
	check_for_launch_defence();

	if (world_frame_counter() > timer) {
		launch_attack_wave(defector_pos, 0);
		//50 seconds
		timer = world_frame_counter() + 1500;
	}
}

main_loop();
